<?php
/**
 * Nakadka strumienia przeksztacajca znaczniki wikszoci szablonw PHP w kod PHP
 * przed wczeniem go za pomoc instrukcji include().
 * 
 * Kod w duej czci bazuje na przykadzie ze strony
 * http://www.php.net/manual/en/function.stream-wrapper-register.php
 * 
 * @author Mike Naberezny (@link http://mikenaberezny.com)
 * @author Paul M. Jones  (@link http://paul-m-jones.com)
 */
class ViewStream {
    /**
     * Bieca pozycja strumienia.
     *
     * @var int
     */
    private $pos = 0;

    /**
     * Strumieniowane dane.
     *
     * @var string
     */
    private $data;

    /**
     * Statystyka strumienia.
     *
     * @var array
     */
    private $stat;

    
    /**
     * Otwarcie pliku skryptu i konwersja znacznikw.
     */
    public function stream_open($path, $mode, $options, &$opened_path) {
        
        // przegld kodu rdowego skryptu
        $path = str_replace('view://', '', $path);
        $this->data = file_get_contents($path);
        
        /**
         * Jeli odczyt si nie uda, trzeba zaktualizowa dane statystyczne, tak by
         * odzwierciedlay rzeczywisty stan pliku, i zakoczy funkcj z bdem
         */
        if ($this->data===false) {
            $this->stat = stat($path);
            return false;
        }

        /**
         * Zamiana znacznikw <?= ?> na dusz wersj <?php echo ?>
         * 
         * Mona rwnie konwertowa znaczniki <%= jako wartoci T_OPEN_TAG_WITH_ECHO
         * ale nie jest to konieczne.
         * 
         * Mona by rwnie przeksztaca bloki PHP <? ?>, ale na razie
         * nie zajmujmy si tym problemem. Prawdopodobnie korzystniejsze byoby
         * zachowanie znacznikw <?php dla wikszych blokw kodu, cho jest to
         * kwestia indywidualnych preferencji. Uwzgldnienie takiego rozwizania
         * z pewnoci znacznie utrudnioby wyszukiwanie znacznikw <?xml
         */
        if (! ini_get('short_open_tag')) {
         $find = '/\<\?\= (.*)? \?>/';
         $replace = "<?php echo \$1 ?>";
         $this->data = preg_replace($find, $replace, $this->data);
        }
                
        /**
         * Zamiana @$ na $this->
         * 
         * Lepszym rozwizaniem byoby ograniczenie wyszukiwania znacznikw @$
         * tylko do obszarw otoczonych znacznikami <?php i ?>. W praktyce jednak
         * znaczniki @$ rzadko wystpuj w innych miejscach, a zastosowanie
         * funkcji str_replace() istotnie zwiksza wydajno kodu.
         */
        $this->data = str_replace('@$', '$this->', $this->data);
        
        /**
         * Funkcja file_get_contents() nie uaktualnia bufora stat, a wykonanie 
         * funkcji stat() spowodowaoby ponowne odwoanie do systemu plikw. Poniewa
         * plik zosta poprawnie odczytany, mona podstawi dane stat
         * i dyrektywa include() bdzie dziaaa waciwie.
         */
        $this->stat = array('mode' => 0100777,
                            'size' => strlen($this->data));

        return true;
    }

    
    /**
     * Odczyt danych ze strumienia.
     */
    public function stream_read($count) {
        $ret = substr($this->data, $this->pos, $count);
        $this->pos += strlen($ret);
        return $ret;
    }

    
    /**
     * Zwrcenie biecej pozycji w strumieniu.
     */
    public function stream_tell() {
        return $this->pos;
    }

    
    /**
     * Zwrcenie informacji, czy bieca pozycja jest kocow pozycj w strumieniu.
     */
    public function stream_eof() {
        return $this->pos >= strlen($this->data);
    }

    
    /**
     * Statystyka strumienia.
     */
    public function stream_stat() {
        return $this->stat;
    }

    
    /**
     * Odszukanie wskazanej pozycji w strumieniu.
     */
    public function stream_seek($offset, $whence) {
        switch ($whence) {
            case SEEK_SET:
                if ($offset < strlen($this->data) && $offset >= 0) {
                $this->pos = $offset;
                    return true;
                } else {
                    return false;
                }
                break;

            case SEEK_CUR:
                if ($offset >= 0) {
                    $this->pos += $offset;
                    return true;
                } else {
                    return false;
                }
                break;

            case SEEK_END:
                if (strlen($this->data) + $offset >= 0) {
                    $this->pos = strlen($this->data) + $offset;
                    return true;
                } else {
                    return false;
                }
                break;

            default:
                return false;
        }
    }
}
?>
